import lplibv2
import time
import random
from math import sin,cos,sqrt,atan2

letters = {
'a':[3,18,33,49,65,81,97,113,4,21,38,54,70,86,102,118,50,51,52,53],
'b':[2,3,4,5,22,38,51,52,53,70,86,102,18,34,50,66,82,98,114,115,116,117],
'c':[4,3,2,17,33,49,65,81,97,114,115,116],
'd':[1,2,3,4,21,38,54,70,86,101,116,115,114,113,97,81,65,49,33,17],
'e':[2,18,34,50,66,82,98,114,3,4,5,51,52,53,115,116,117],
'f':[2,18,34,50,66,82,98,114,3,4,5,51,52,53],
'g':[22,5,4,3,2,17,33,49,65,81,97,114,115,116,117,102,86,69,70,71],
'h':[1,17,33,49,65,81,97,113,6,22,38,54,70,86,102,118,50,51,52,53],
'i':[3,4,5,20,36,52,68,84,100,115,116,117],
'j':[3,4,5,6,21,37,53,69,85,101,116,115,98,82],
'k':[2,18,34,50,66,82,98,114,51,36,21,6,67,84,101,118],
'l':[2,18,34,50,66,82,98,114,115,116,117],
'm':[1,17,33,49,65,81,97,113,6,22,38,54,70,86,102,118,18,21,35,36],
'n':[1,17,33,49,65,81,97,113,6,22,38,54,70,86,102,118,34,51,68,85],
'o':[2,3,4,5,22,38,54,70,86,102,117,116,115,114,97,81,65,49,33,17],
'p':[114,98,82,66,50,34,18,3,4,5,22,38,53,52,51],
'q':[2,3,4,5,22,38,54,70,86,101,116,115,114,97,81,65,49,33,17,84,118,119],
'r':[2,18,34,50,66,82,98,114,3,4,21,37,52,51,67,84,101,118],
's':[21,4,3,2,17,33,50,51,52,69,85,101,116,115,114,97],
't':[2,3,4,5,6,20,36,52,68,84,100,116],
'u':[6,22,38,54,70,86,102,117,116,115,114,97,81,65,49,33,17,1],
'v':[6,22,38,54,70, 85,101 ,116,115, 98,82 ,65,49,33,17,1],
'w':[1,17,33,49,65,81,97,113,6,22,38,54,70,86,102,118,98,101,83,84],
'x':[1,17,34,51,68,85,102,118,6,22,37,52,67,82,97,113],
'y':[116,100,84,68,52,35,37,18,22,2,6],
'z':[0,1,2,3,4,5,6,7,22,37,52,67,82,97,112,113,114,115,116,117,118,119],
'0':[2,3,4,5,22,38,54,70,86,102,117,116,115,114,97,81,65,49,33,17,34,51,68,85],
'1':[19,4,20,36,52,68,84,100,116,115,117],
'2':[17,2,3,4,5,22,38,53,68,83,98,113,114,115,116,117,118],
'3':[2,3,4,21,37,52,51,50,69,85,101,116,115,114],
'4':[54,53,52,51,50,34,18,2,5,21,37,53,69,85,101,117],
'5':[6,5,4,3,2,18,34,50,51,52,53,70,86,102,117,116,115,114],
'6':[22,5,4,3,18,34,50,66,82,98,115,116,117,102,86,69,68,67],
'7':[17,1,2,3,4,5,6,22,37,52,68,84,100,116],
'8':[51,34,18,3,4,21,37,52,67,82,98,115,116,101,85,68],
'9':[52,51,34,18,3,4,21,37,53,69,85,101,117],
':':[17,18,33,34,97,98,113,114],
'-':[48,49,50,51,64,65,66,67]
}


letterbuffers=dict()
for k,v in letters.iteritems():
    lbuff = [0]*64
    low = 8
    for addr in v:
        x = addr%16
        if low>x: low = x
    for addr in v:
        x = addr%16-low
        y = addr/16
        
        newaddr = x*8+(-y+7)
        lbuff[newaddr]=1
    letterbuffers[k]=lbuff

def trimbuff(buff):
    for r in range(len(buff)/8-1,0,-1):
        if sum([buff[r*8+x] for x in range(8)]) == 0:
            del buff[r*8:r*8+8]
        else:
            break

def wordbuffer(data,space=1):
    data=data.lower()
    wordbuff = []
    for char in data:
        if(" "==char):
            wordbuff += [0]*32
        elif(char in letterbuffers.keys()):
            wordbuff += letterbuffers[char]
            trimbuff(wordbuff)
            wordbuff += [0]*8*space
            
    return wordbuff
    
def scrollbuffer(dev,word,pauses=0):
    word = [0]*64 + word + [0]*64#empty space at ends for scrolling over
    rows = len(word)/8
    for i in range(rows+8):
        start = i
        stop = min(rows,i+8)
        frame = word[start*8:stop*8]
        dev.bufferwrite(frame)
        if pauses: time.sleep(pauses)

def sinscroll(dev,secs):
    start = time.time()
    while((time.time()-start)<secs):
        buff = [0]*64
        for x in range(8):
            ya = int( 4+4*sin(x/2.0 + time.time()*5.0) )
            buff[x*8+ya] = 51
            yb = int( 4+4*cos(x/2.0 + time.time()*5.0) )
            buff[x*8+yb] = 51
            if (x%2):
                for yy in max(range(ya+1,yb),range(yb+1,ya)):
                    buff[x*8+yy] += 1
        dev.bufferwrite(buff)
        
def bounce(dev,secs):
    start = time.time()
    while((time.time()-start)<secs):
        buff = [0]*64
        dist = 5+5*sin(time.time()*3.0)
        for x in range(8):
            for y in range(8):
                xx =x-3.5
                yy =y-3.5
                r = max(min(int(abs(dist-sqrt(xx*xx+yy*yy))),3),0)
                g = max(min(int(abs(dist-sqrt(xx*xx+yy*yy)))-3,3),0)
                buff[x*8+y] = r+g*16
        dev.bufferwrite(buff)
        
def tunnel(dev,secs):
    start = time.time()
    while((time.time()-start)<secs):
        buff = [0]*64
        for x in range(8):
            for y in range(8):
                xx =x-3.5
                yy =y-3.5
                dist = sqrt(xx*xx+yy*yy)-time.time()*6.0
                gdist = dist%4.0
                a = atan2(yy,xx)
                ga = (time.time())%6.28318 - 3.14159
                r = int(  max(0,3.5*sin(dist))  )
                g = int(  max(0,3.5*sin(a*4.0+time.time()*3.0))  )
                buff[x*8+y] = r+g*16
        dev.bufferwrite(buff)

def plasma(dev,secs):
    start = time.time()
    while((time.time()-start)<secs):
        buff = [0]*64
        for x in range(8):
            for y in range(8):
                r = int(1.7+1.7*sin(x+time.time()*4.0+sin(y)*2.0))
                g = int(1.7+1.7*sin(y+time.time()*3.0+sin(x)))
                buff[x*8+y] = r+g*16
        dev.bufferwrite(buff)
    
if __name__ == "__main__":
    try:
        msgs = []
        msgs.append(wordbuffer("syntax 2013"))
        msgs.append(wordbuffer("greets to all"))

        for msg in msgs: #colour them all!
            for i in range(len(msg)):
                msg[i] *= 3*16
        effects = [plasma,tunnel,sinscroll,bounce]
        
        d = lplibv2.LpMidi()
        d.open()
        
        scrollbuffer(d,msgs[0])
        effects[2](d,7)
        effects[3](d,7)
        scrollbuffer(d,msgs[1])
            
    except KeyboardInterrupt:
        d.reset()
        d.close()